#region usings
using System;
using System.ComponentModel.Composition;
 
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
 
using VVVV.Core.Logging;
#endregion usings
 
namespace VVVV.Nodes
{
    #region PluginInfo
    [PluginInfo(Name = "IntersectCircles", Category = "2d", Help = "Basic template with one value in/out", Tags = "")]
    #endregion PluginInfo
    public class C2dIntersectCirclesNode : IPluginEvaluate
    {
        #region fields & pins
        [Input("Centers")]
        ISpread<Vector2D> FCenters;
 
        [Input("Radius", DefaultValue = 1.0)]
        ISpread<double> FRadii;
        
    	[Output("Intersection")]
        ISpread<Vector2D> FIntersections;
 
    	
       // [Import()]
       // ILogger FLogger;
        #endregion fields & pins
 
        //called when data for any output pin is requested
    	
    	public void Evaluate(int SpreadMax)
        {
        
          FIntersections.SliceCount = 0;
        
           
        	
               	for (int i = 0; i < SpreadMax; i++)
                {
              
                   for (int j = i + 1; j < SpreadMax; j++)
                  {    
                    Vector2D s1;
                    Vector2D s2;
 
                    if ( CircleIntersection(FCenters[i], FRadii[i], FCenters[j], FRadii[j], out s1, out s2))
 
                    FIntersections.Add(s1);
                    FIntersections.Add(s2);    
                }
            }
        }
 
        private bool CircleIntersection (Vector2D c1, double c1r, Vector2D c2, double c2r, out Vector2D p1, out Vector2D p2)
        {
            p1 = new Vector2D();
            p2 = new Vector2D();
 
            //Calculate distance between centres of circle
            double d = !(c1 - c2);
            double m = c1r + c2r;
            double n = c1r - c2r;
 
            if (n < 0)
                n = n * -1;
        	
            
 
            //Solve for a
            double a = ( c1r * c1r - c2r * c2r + d * d ) / (2 * d);
 
            //Solve for h
            double h = Math.Sqrt( c1r * c1r - a * a );
 
            //Calculate point p, where the line through the circle intersection points crosses the line between the circle centers.
            //Vector2D p;
            
            double px = c1.x + ( a / d ) * ( c2.x -c1.x );
            double py = c1.y + ( a / d ) * ( c2.y -c1.y );
 
            //No solns  //Circle are contained within each other //Circles are the same
            if ( d > m || d < n || (d == 0 && c1r == c2r))
            	{
				return false;
			}
        	
        	//1 soln , circles are touching
            if ( d == c1r + c2r ) 
            {
                p1.x = px;
            	p1.y = py;
            	
            	return true;  
            }
 
            //2solns      
        	//if ( d != c1r + c2r  ) 
            {
        	p1.x = px + ( h / d ) * ( c2.y - c1.y );
            p1.y = py - ( h / d ) * ( c2.x - c1.x );
 
            p2.x = px - ( h / d ) * ( c2.y - c1.y );
            p2.y = py + ( h / d ) * ( c2.x - c1.x );
            return true;
            }
		return false;	
		}     
        	
        	
        }
        	
     }	
        
        	
    


